# Mega Man 3

## Where is the options page?

The [player options page for this game](../player-options) contains all the options you need to configure and export a
config file.

## What does randomization do to this game?

Weapons received from Robot Masters, access to each individual stage (including Doc Robot stages), and Items from Dr. Light are randomized
into the multiworld. Access to the Wily Stages is locked behind clearing the 4 Doc Robot stages and defeating Break Man. The game is complete upon 
viewing the ending sequence after defeating Gamma.

## What Mega Man 3 items can appear in other players' worlds?
- Robot Master weapons
- Robot Master Access Codes (stage access)
- Doc Robot Access Codes (stage access)
- Rush Coil/Jet/Marine
- 1-Ups
- E-Tanks
- Health Energy (L)
- Weapon Energy (L)

## What is considered a location check in Mega Man 3?
- The defeat of a Robot Master, Doc Robot, or Wily Boss
- Receiving a weapon or Rush item from Dr. Light
- Optionally, 1-Ups and E-Tanks present within stages
- Optionally, Weapon and Health Energy pickups present within stages

## When the player receives an item, what happens?
A sound effect will play based on the type of item received, and the effects of the item will be immediately applied, 
such as unlocking the use of a weapon mid-stage. If the effects of the item cannot be fully applied (such as receiving 
Health Energy while at full health), the remaining are withheld until they can be applied.

## How do I access the Doc Robot stages?
By pressing Select on the Robot Master screen, the screen will transition between Robot Masters and
Doc Robots.

## Useful Information
* **NesHawk is the recommended core for this game!** Players using QuickNes (or QuickerNes) will experience graphical 
  glitches while in Gemini Man's stage and fighting Gamma.
* Pressing A+B+Start+Select while in a stage will take you to the Game Over screen, allowing you to leave the stage. 
  Your E-Tanks will be preserved.
* Your current progress through the Wily stages is saved to the multiworld, allowing you to return to the last stage you
  reached should you need to leave and enter a Robot Master stage. If you need to return to an earlier Wily stage, holding 
  Select while entering Break Man's stage will take you to Wily 1.
* When Random Weaknesses are enabled, Break Man's weakness will be changed from Mega Buster to one random weapon.


## What is EnergyLink?
EnergyLink is an energy storage supported by certain games that is shared across all worlds in a multiworld. In Mega Man
 3, when enabled, drops from enemies are not applied directly to Mega Man and are instead deposited into the EnergyLink.
Half of the energy that would be gained is lost upon transfer to the EnergyLink. 

Energy from the EnergyLink storage can be converted into health, weapon energy, and lives at different conversion rates.
You can find out how much of each type you can pull using `/pool` in the client. Additionally, you can have it 
automatically pull from the EnergyLink storage to keep Mega Man healed using the `/autoheal` command in the client. 
Finally, you can use the `/request` command to request a certain type of energy from the storage.

## Plando Palettes
The palette shuffle option supports specifying a specific palette for a given weapon/Robot Master. The format for doing 
so is `Character-Color1|Color2;Option`. Character is the individual that this should apply to, and can only be one of 
the following:
- Mega Buster
- Gemini Laser
- Needle Cannon
- Hard Knuckle
- Magnet Missile
- Top Spin
- Search Snake
- Spark Shot
- Shadow Blade
- Rush Coil
- Rush Jet
- Rush Marine
- Needle Man
- Magnet Man
- Gemini Man
- Hard Man
- Top Man
- Snake Man
- Spark Man
- Shadow Man
- Doc Robot

Colors attempt to map a list of HTML-defined colors to what the NES can render. A full list of applicable colors can be
found [here](https://github.com/MultiworldGG/MultiworldGG/blob/main/worlds/mm2/Color.py#L11). Alternatively, colors can 
be supplied directly using `$xx` format. A full list of NES colors can be found [here](https://www.nesdev.org/wiki/PPU_palettes#2C02).

You can also pass only one color (such as `Mega Buster-Red`) and it will interpret a second color based off of the color
given. Additionally, passing only colors (such as `Red|Blue`) and not any specific boss/weapon will apply that color to 
all weapons/bosses that did not have a prior color specified.

The option is the method to be used to set the palettes of the remaining bosses/weapons, and will not overwrite any 
plando placements.

## Plando Weaknesses
Plando Weaknesses allows you to override the amount of damage a boss should take from a given weapon, ignoring prior 
weaknesses generated by strict/random weakness options. Formatting for this is as follows:
```yaml
plando_weakness:
  Needle Man:
    Top Spin: 0
    Hard Knuckle: 4
```
This would cause Air Man to take 4 damage from Hard Knuckle, and 0 from Top Spin.

Note: it is possible that plando weakness is not be respected should the plando create a situation in which the game 
becomes impossible to complete. In this situation, the damage would be boosted to the minimum required to defeat the 
Robot Master.


## Unique Local Commands
- `/pool` Only present with EnergyLink, prints the max amount of each type of request that could be fulfilled.
- `/autoheal` Only present with EnergyLink, will automatically drain energy from the EnergyLink in order to 
restore Mega Man's health.
- `/request <amount> <type>` Only present with EnergyLink, sends a request of a certain type of energy to be pulled from
the EnergyLink. Types are as follows:
  - `HP` Health
  - `NE` Needle Cannon
  - `MA` Magnet Missile
  - `GE` Gemini Laser
  - `HA` Hard Knuckle
  - `TO` Top Spin
  - `SN` Search Snake
  - `SP` Spark Shot
  - `SH` Shadow Blade
  - `RC` Rush Coil
  - `RM` Rush Marine
  - `RJ` Rush Jet
  - `1U` Lives